
// SC540N1_WebRTCDlg.cpp : implementation file
//

#include "stdafx.h"
#include "SC540N1_WebRTC.h"
#include "SC540N1_WebRTCDlg.h"
#include "afxdialogex.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CAboutDlg dialog used for App About
VOID SC_DEBUG( TCHAR * fmt, ... )
{
	TCHAR pszDebugDumpMessage[ 256 ] = "[QC] ";

	va_list marker;

	va_start( marker, fmt );

	vsprintf( pszDebugDumpMessage + 5, fmt, marker );

	va_end( marker );

	strcat( pszDebugDumpMessage, "\n" );

	OutputDebugString( pszDebugDumpMessage );
}


QRETURN webrtc_login_callback( PVOID pChatter /*IN*/, ULONG nPeerID /*IN*/, CHAR * pszPeerUserName /*IN*/, PVOID pUserData /*IN*/ )
{
	SC_DEBUG ("webrtc_login_callback()  %u , %s ",nPeerID, pszPeerUserName);

	return QCAP_RT_OK;
}

QRETURN webrtc_logout_callback( PVOID pChatter /*IN*/, ULONG nPeerID /*IN*/,  PVOID pUserData /*IN*/ )
{
	SC_DEBUG ("webrtc_logout_callback()  %u ", nPeerID);

	return QCAP_RT_OK;
}


QRETURN webrtc_peer_connect_callback( PVOID pChatter /*IN*/, ULONG nPeerID /*IN*/, QRESULT nConnectionStatus /*IN*/, PVOID pUserData /*IN*/ )
{	
	CSC540N1_WebRTCDlg* m_pMainDialog =  (CSC540N1_WebRTCDlg * ) pUserData;

	if( m_pMainDialog->m_nStartChatState >= 0x00000001 ) {

		SC_DEBUG ("webrtc_peer_connected_callback()  %u ", nPeerID);

		m_pMainDialog->GetDlgItem( IDC_BUTTON_CONNECT )->EnableWindow( FALSE );

		m_pMainDialog->GetDlgItem( IDC_BUTTON_DISCONNECT )->EnableWindow( TRUE );
	}
	
	return QCAP_RT_OK;
}

QRETURN webrtc_peer_disconnect_callback( PVOID pChatter /*IN*/, ULONG nPeerID /*IN*/, PVOID pUserData /*IN*/ )
{	
	CSC540N1_WebRTCDlg* m_pMainDialog =  (CSC540N1_WebRTCDlg * ) pUserData;

	if( m_pMainDialog->m_nStartChatState >= 0x00000001 ) {

		SC_DEBUG ("webrtc_peer_disconnected_callback()  %u ", nPeerID);

		m_pMainDialog->GetDlgItem( IDC_BUTTON_CONNECT )->EnableWindow( TRUE );

		m_pMainDialog->GetDlgItem( IDC_BUTTON_DISCONNECT )->EnableWindow( FALSE );
	}
	
	return QCAP_RT_OK;
}


QRETURN on_no_signal_detected_callback( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{

	CSC540N1_WebRTCDlg* m_pMainDialog =  (CSC540N1_WebRTCDlg * ) pUserData;

	m_pMainDialog->m_nDeviceVideoWidth = 0;

	m_pMainDialog->m_nDeviceVideoHeight = 0;

	m_pMainDialog->m_bDeviceVideoIsInterleaved = FALSE;

	m_pMainDialog->m_dDeviceVideoFrameRate = 0.0;

	m_pMainDialog->m_nDeviceAudioChannel = 0;

	m_pMainDialog->m_nDeviceAudioBitsPerSample = 0;

	m_pMainDialog->m_nDeviceAudioSampleFrequency = 0;

	SC_DEBUG( "on_no_signal_detected_callback()" );

	return QCAP_RT_OK;
}

QRETURN on_no_signal_removed_callback( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
	CSC540N1_WebRTCDlg* m_pMainDialog =  (CSC540N1_WebRTCDlg * ) pUserData;

	m_pMainDialog->m_nDeviceVideoWidth = 0;

	m_pMainDialog->m_nDeviceVideoHeight = 0;

	m_pMainDialog->m_bDeviceVideoIsInterleaved = FALSE;

	m_pMainDialog->m_dDeviceVideoFrameRate = 0.0;

	m_pMainDialog->m_nDeviceAudioChannel = 0;

	m_pMainDialog->m_nDeviceAudioBitsPerSample = 0;

	m_pMainDialog->m_nDeviceAudioSampleFrequency = 0;

	SC_DEBUG( "on_no_signal_removed_callback()" );

	return QCAP_RT_OK;
}    

QRETURN on_format_changed_callback( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, ULONG nVideoWidth, ULONG nVideoHeight, BOOL bVideoIsInterleaved, double dVideoFrameRate, ULONG nAudioChannels, ULONG nAudioBitsPerSample, ULONG nAudioSampleFrequency, PVOID pUserData )
{
	CSC540N1_WebRTCDlg* m_pMainDialog =  (CSC540N1_WebRTCDlg * ) pUserData;

	m_pMainDialog->m_nDeviceVideoWidth = nVideoWidth;

	m_pMainDialog->m_nDeviceVideoHeight = nVideoHeight;

	m_pMainDialog->m_bDeviceVideoIsInterleaved = bVideoIsInterleaved;

	m_pMainDialog->m_dDeviceVideoFrameRate = dVideoFrameRate;

	m_pMainDialog->m_nDeviceAudioChannel = nAudioChannels;

	m_pMainDialog->m_nDeviceAudioBitsPerSample = nAudioBitsPerSample;

	m_pMainDialog->m_nDeviceAudioSampleFrequency = nAudioSampleFrequency;

	SC_DEBUG( "on_format_changed_callback( %d, %d, %d, %2.3f, %d, %d, %d )", nVideoWidth, nVideoHeight, bVideoIsInterleaved, dVideoFrameRate, nAudioChannels, nAudioBitsPerSample, nAudioSampleFrequency );
	
	return QCAP_RT_OK;
}

QRETURN on_video_preview_callback( PVOID pDevice, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData )
{
	CSC540N1_WebRTCDlg* m_pMainDialog =  (CSC540N1_WebRTCDlg * ) pUserData;	
	
	static int count = 0;
	
	if( m_pMainDialog->m_nStartChatState >= 0x00000001 ) {

		char buffer[64];

		sprintf( buffer, "%s -  %d", m_pMainDialog->m_chatter_username, count);

		count ++ ;

		QCAP_SET_OSD_TEXT( m_pMainDialog->m_pDevice, 0, 0, 0, 0, 0, buffer, "Arial", QCAP_FONT_STYLE_BOLD, 72, 0xFFFFFFFF, 0xFFFF0000, 0xFF, 0, 0 );

		QCAP_SET_VIDEO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( m_pMainDialog->m_pSender, 
			
															  0, 
															  
															  QCAP_COLORSPACE_TYEP_YV12, 
			
															  m_pMainDialog->m_nDeviceVideoWidth, 
															  
															  m_pMainDialog->m_nDeviceVideoHeight, 
															  
															  pFrameBuffer,
															  
															  nFrameBufferLen );
	}

    return QCAP_RT_OK;
}

QRETURN on_audio_preview_callback( PVOID pDevice, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData )
{
	CSC540N1_WebRTCDlg* m_pMainDialog =  (CSC540N1_WebRTCDlg * ) pUserData;

	if( m_pMainDialog->m_nStartChatState >= 0x00000001 ) {

		QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( m_pMainDialog->m_pSender, 
			
															  0, 
															  
															  pFrameBuffer,
															  
															  nFrameBufferLen );
	}

	
    return QCAP_RT_OK;
}


QRETURN video_client_callback( PVOID pClient /*IN*/, UINT iSessionNum, double dSampleTime /*IN*/, BYTE * pStreamBuffer /*IN*/, ULONG nStreamBufferLen /*IN*/, BOOL bIsKeyFrame /*IN*/, PVOID pUserData /*IN*/ )
{
	//SC_DEBUG( "video_client_callback : %f , %u", dSampleTime,  nStreamBufferLen );

	return QCAP_RT_OK;
}

QRETURN video_decode_client_callback( PVOID pClient /*IN*/, UINT iSessionNum, double dSampleTime /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, PVOID pUserData /*IN*/ )
{
	//SC_DEBUG( "video_decode_client_callback : %f , %u", dSampleTime,  nFrameBufferLen );

	return QCAP_RT_OK;
}



class CAboutDlg : public CDialogEx
{
public:
	CAboutDlg();

// Dialog Data
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Implementation
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialogEx(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialogEx)
END_MESSAGE_MAP()


// CSC540N1_WebRTCDlg dialog


CSC540N1_WebRTCDlg::CSC540N1_WebRTCDlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(CSC540N1_WebRTCDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CSC540N1_WebRTCDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_WINDOWS_PEER, m_windows_peer);
	DDX_Control(pDX, IDC_WINDOWS_MAIN, m_windows_main);
	DDX_Control(pDX, IDC_LIST3, m_list_peer);
	DDX_Control(pDX, IDC_EDIT_NAME, m_edit_name);
	DDX_Control(pDX, IDC_EDIT_IP, m_edit_ip);
	DDX_Control(pDX, IDC_EDIT_PORT, m_edit_port);
}

BEGIN_MESSAGE_MAP(CSC540N1_WebRTCDlg, CDialogEx)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_DESTROY()
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_BUTTON_UPDATE, &CSC540N1_WebRTCDlg::OnBnClickedButtonUpdate)
	ON_BN_CLICKED(IDC_BUTTON_CONNECT, &CSC540N1_WebRTCDlg::OnBnClickedButtonConnect)
	ON_BN_CLICKED(IDC_BUTTON_DISCONNECT, &CSC540N1_WebRTCDlg::OnBnClickedButtonDisconnect)
	ON_BN_CLICKED(IDC_BUTTON_LOGIN, &CSC540N1_WebRTCDlg::OnBnClickedButtonLogin)
	ON_BN_CLICKED(IDC_BUTTON_LOGOUT, &CSC540N1_WebRTCDlg::OnBnClickedButtonLogout)
END_MESSAGE_MAP()


// CSC540N1_WebRTCDlg message handlers

BOOL CSC540N1_WebRTCDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		BOOL bNameValid;
		CString strAboutMenu;
		bNameValid = strAboutMenu.LoadString(IDS_ABOUTBOX);
		ASSERT(bNameValid);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here

    GetDlgItem( IDC_BUTTON_LOGIN )->EnableWindow( TRUE );

	GetDlgItem( IDC_BUTTON_LOGOUT )->EnableWindow( FALSE );

	GetDlgItem( IDC_BUTTON_UPDATE )->EnableWindow( FALSE );

	GetDlgItem( IDC_BUTTON_CONNECT )->EnableWindow( FALSE );

	GetDlgItem( IDC_BUTTON_DISCONNECT )->EnableWindow( FALSE );


	// INITIALIZE COM LIBRARY
	//
	HRESULT hr = CoInitialize( NULL );

	// INITIALIZE VARIABLE
	// 

	m_pDevice = NULL;

	m_nDeviceVideoWidth = 0;

	m_nDeviceVideoHeight = 0;

	m_bDeviceVideoIsInterleaved = FALSE;

	m_dDeviceVideoFrameRate = 0.0;

	m_nDeviceAudioChannel = 0;

	m_nDeviceAudioBitsPerSample= 0;

	m_nDeviceAudioSampleFrequency = 0;

	m_pChatter = NULL;

	m_pSender = NULL;

	m_pReceiver = NULL;

	m_nStartChatState = 0x00000000;
	
	srand(time(0));

	sprintf( m_chatter_username, "default%02d", rand()%100 );

	m_edit_name.SetWindowText(m_chatter_username);

	m_edit_ip.SetWindowText("127.0.0.1");

	m_edit_port.SetWindowText("8888");

	// INITIALIZE DEVICE RESOURCE
	// 
	QCAP_CREATE( "QP0203 PCI", 0, m_windows_main.m_hWnd, &m_pDevice, TRUE, FALSE );

	QCAP_REGISTER_FORMAT_CHANGED_CALLBACK( m_pDevice, on_format_changed_callback, this );

	QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK( m_pDevice, on_no_signal_detected_callback, this );

	QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK( m_pDevice, on_no_signal_removed_callback, this );

	QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK( m_pDevice, on_video_preview_callback, this );

	QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK( m_pDevice, on_audio_preview_callback, this );

	QCAP_RUN( m_pDevice );

	QCAP_SET_AUDIO_VOLUME(m_pDevice , 0);

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CSC540N1_WebRTCDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialogEx::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CSC540N1_WebRTCDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CSC540N1_WebRTCDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}



void CSC540N1_WebRTCDlg::OnDestroy()
{
	CDialogEx::OnDestroy();

	// TODO: Add your message handler code here
	m_nStartChatState = 0x00000000;

	if( m_pChatter ) {

		QCAP_DESTROY_WEBRTC_CHATTER( m_pChatter );

		m_pChatter= NULL;
	}

	if( m_pSender ) {

		QCAP_STOP_BROADCAST_SERVER( m_pSender );

		QCAP_DESTROY_BROADCAST_SERVER( m_pSender );

		m_pSender = NULL;
	}

	if( m_pReceiver ) {

		QCAP_STOP_BROADCAST_CLIENT( m_pReceiver );

		QCAP_DESTROY_BROADCAST_CLIENT( m_pReceiver );

		m_pReceiver = NULL;
	}

	// UNINITIALIZE DEVICE RESOURCE
	// 
	if( m_pDevice ) {

		QCAP_STOP( m_pDevice );

		QCAP_DESTROY( m_pDevice );

		m_pDevice = NULL;
	}


	// UNINITIALIZE COM LIBRARY
	// 
	CoUninitialize();
}


void CSC540N1_WebRTCDlg::OnTimer(UINT_PTR nIDEvent)
{
	// TODO: Add your message handler code here and/or call default	

	CDialogEx::OnTimer(nIDEvent);
}


void CSC540N1_WebRTCDlg::OnBnClickedButtonUpdate()
{
	// TODO: Add your control notification handler code here
	ULONG user_count = 0, n_peer_id = 0;

	CHAR *psz_peer_name;

	CHAR peer_column_tmp[ MAX_PATH ];

	memset(peer_column_tmp, 0x00, sizeof(peer_column_tmp) );

	m_list_peer.ResetContent();

	QRESULT returns = QCAP_ENUM_WEBRTC_USER_IN_CHATROOM( m_pChatter, &n_peer_id, &psz_peer_name, FALSE );

	SC_DEBUG( "QCAP_ENUM_WEBRTC_USER_IN_CHATROOM rs %u, n_peer_id : %u, psz_peer_name %s", returns, n_peer_id, psz_peer_name );

	sprintf(peer_column_tmp, "%u, %s",n_peer_id, psz_peer_name );

	if  (returns == QCAP_RS_SUCCESSFUL )
	{
		m_list_peer.AddString( peer_column_tmp);
		
		user_count ++;
    }


	while( returns == QCAP_RS_SUCCESSFUL ) {

		returns = QCAP_ENUM_WEBRTC_USER_IN_CHATROOM( m_pChatter, &n_peer_id, &psz_peer_name, TRUE );

		if  (returns == QCAP_RS_SUCCESSFUL )
		{
			SC_DEBUG( "QCAP_ENUM_WEBRTC_USER_IN_CHATROOM rs %u, n_peer_id : %u, psz_peer_name %s", returns, n_peer_id, psz_peer_name );

			memset(peer_column_tmp, 0x00, sizeof(peer_column_tmp) );
			
			sprintf(peer_column_tmp, "%u, %s",n_peer_id, psz_peer_name );

			m_list_peer.AddString( peer_column_tmp);

			user_count ++;
		}
	}


}


void CSC540N1_WebRTCDlg::OnBnClickedButtonConnect()
{
	// TODO: Add your control notification handler code here
	CString peer_id_str;		

	if( m_nDeviceVideoWidth == 0 || m_nDeviceVideoHeight == 0 ) {
		return;
	}

	int uiSelection = -1;
		
	uiSelection	= m_list_peer.GetCurSel();

	if ( uiSelection == -1) return;

	m_list_peer.GetText( uiSelection, peer_id_str);


	if( m_pChatter && 
		
		m_pSender && 
		
		m_pReceiver ) {

		int peer_id = atoi(peer_id_str.Left(2));

		QCAP_START_WEBRTC_CHAT( m_pChatter, peer_id );
	}

}


void CSC540N1_WebRTCDlg::OnBnClickedButtonDisconnect()
{
	// TODO: Add your control notification handler code here

	if( m_pChatter ) {

		QCAP_STOP_WEBRTC_CHAT( m_pChatter );
	}

}


void CSC540N1_WebRTCDlg::OnBnClickedButtonLogin()
{
	// TODO: Add your control notification handler code here
		
	CString username, chatroom_ip, chatroom_port;	

	m_edit_name.GetWindowTextA(username);

	m_edit_ip.GetWindowTextA(chatroom_ip);

	m_edit_port.GetWindowTextA(chatroom_port);

	memset( m_chatter_username , 0x00 , sizeof(m_chatter_username));

	sprintf( m_chatter_username, "%s", username );

	QCAP_CREATE_WEBRTC_CHATTER( chatroom_ip.GetBuffer(0), atoi(chatroom_port), username.GetBuffer(0), &m_pChatter , &m_chatter_id);

    QCAP_REGISTER_WEBRTC_CHATROOM_LOGIN_CALLBACK( m_pChatter, webrtc_login_callback, this );

    QCAP_REGISTER_WEBRTC_CHATROOM_LOGOUT_CALLBACK( m_pChatter, webrtc_logout_callback, this );

    QCAP_REGISTER_WEBRTC_PEER_CONNECTED_CALLBACK( m_pChatter, webrtc_peer_connect_callback, this );
    
    QCAP_REGISTER_WEBRTC_PEER_DISCONNECTED_CALLBACK( m_pChatter, webrtc_peer_disconnect_callback, this );


	if( m_pReceiver == NULL ) {

		QCAP_CREATE_WEBRTC_RECEIVER( m_pChatter, 0, &m_pReceiver, QCAP_DECODER_TYPE_SOFTWARE, m_windows_peer.m_hWnd, TRUE, FALSE );

		if( m_pReceiver ) {

			QCAP_REGISTER_VIDEO_BROADCAST_CLIENT_CALLBACK(m_pReceiver, video_client_callback, this);

			QCAP_REGISTER_VIDEO_DECODER_BROADCAST_CLIENT_CALLBACK(m_pReceiver, video_decode_client_callback, this);

			QCAP_START_BROADCAST_CLIENT( m_pReceiver );

			QCAP_SET_AUDIO_BROADCAST_CLIENT_VOLUME( m_pReceiver, 0,  100);			
		}
	}

	if( m_pSender == NULL ) {

		QCAP_CREATE_WEBRTC_SENDER( m_pChatter, 0, &m_pSender );

		if( m_pSender ) {

			ULONG      cx = m_nDeviceVideoWidth;
		
			ULONG      cy = m_nDeviceVideoHeight;
		
			double     fps = m_dDeviceVideoFrameRate; if( m_bDeviceVideoIsInterleaved ) { fps /= 2; }
		
			ULONG      channels = m_nDeviceAudioChannel;
		
			ULONG      bits = m_nDeviceAudioBitsPerSample;
		
			ULONG      freq = m_nDeviceAudioSampleFrequency;

			QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY( m_pSender, 						
														      0, 															 
												              QCAP_ENCODER_TYPE_SOFTWARE, 															  
											                  QCAP_ENCODER_FORMAT_H264, 															  
											                  QCAP_COLORSPACE_TYEP_YV12, 															  
											                  720, 
											                  480,															  
											                  fps, 															  
											                  QCAP_RECORD_MODE_CBR, 															  
											                  8000, 															  
											                  8 * 1024 * 1024, 															  
											                  30,  															  
											                  0,  0, 															  
											                  NULL, FALSE, FALSE, QCAP_BROADCAST_FLAG_NETWORK | QCAP_BROADCAST_FLAG_ENCODE );

            QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY( m_pSender, 						
            										          0, 															  
            		                                          QCAP_ENCODER_TYPE_SOFTWARE, 															  
            										          QCAP_ENCODER_FORMAT_PCM, 															  
            										          channels, 															  
            										          bits, 															  
            										          freq );
            
			QCAP_START_BROADCAST_SERVER( m_pSender );
		}

		m_nStartChatState = 0x00000001;
	}


    GetDlgItem( IDC_BUTTON_LOGIN )->EnableWindow( FALSE );

	GetDlgItem( IDC_BUTTON_LOGOUT )->EnableWindow( TRUE );

	GetDlgItem( IDC_BUTTON_UPDATE )->EnableWindow( TRUE );

	GetDlgItem( IDC_BUTTON_CONNECT )->EnableWindow( TRUE );

	GetDlgItem( IDC_BUTTON_DISCONNECT )->EnableWindow( FALSE );
}


void CSC540N1_WebRTCDlg::OnBnClickedButtonLogout()
{
	// TODO: Add your control notification handler code here
	m_nStartChatState = 0x00000000;

	if( m_pChatter ) {

		QCAP_DESTROY_WEBRTC_CHATTER( m_pChatter );

		m_pChatter= NULL;
	}

	if( m_pSender ) {

		QCAP_STOP_BROADCAST_SERVER( m_pSender );

		QCAP_DESTROY_BROADCAST_SERVER( m_pSender );

		m_pSender = NULL;
	}

	if( m_pReceiver ) {

		QCAP_STOP_BROADCAST_CLIENT( m_pReceiver );

		QCAP_DESTROY_BROADCAST_CLIENT( m_pReceiver );

		m_pReceiver = NULL;
	}

    GetDlgItem( IDC_BUTTON_LOGIN )->EnableWindow( TRUE );

	GetDlgItem( IDC_BUTTON_LOGOUT )->EnableWindow( FALSE );

	GetDlgItem( IDC_BUTTON_UPDATE )->EnableWindow( FALSE );

	GetDlgItem( IDC_BUTTON_CONNECT )->EnableWindow( FALSE );

	GetDlgItem( IDC_BUTTON_DISCONNECT )->EnableWindow( FALSE );

}
